%------------------------------------------------------------------------------
% File     : CSR119^3 : TPTP v9.2.0. Released v5.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Did someone like Bill in 2009?
% Version  : Especial.
% English  : During 2009 Mary liked Bill and Sue liked Bill. Is it the case
%            that someone liked Bill during 2009?

% Refs     : [BP10]  Benzmueller & Pease (2010), Progress in Automating Hig
%          : [Ben11] Benzmueller (2011), Email to Geoff Sutcliffe
% Source   : [Ben11]
% Names    : 

% Status   : Theorem
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0, 0.18 v7.5.0, 0.14 v7.4.0, 0.44 v7.3.0, 0.56 v7.2.0, 0.50 v7.1.0, 0.62 v7.0.0, 0.86 v6.4.0, 0.83 v6.3.0, 0.80 v6.2.0, 0.71 v6.1.0, 0.86 v5.5.0, 0.83 v5.4.0, 0.60 v5.3.0
% Syntax   : Number of formulae    : 5014 (1668 unt;1435 typ;   0 def)
%            Number of atoms       : 7502 ( 406 equ; 192 cnn)
%            Maximal formula atoms :   16 (   2 avg)
%            Number of connectives : 16665 ( 192   ~;  77   |;1314   &;14029   @)
%                                         ( 105 <=>; 948  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   5 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  : 1319 (1319   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 1440 (1436 usr; 995 con; 0-7 aty)
%            Number of variables   : 2571 (   2   ^;2075   !; 494   ?;2571   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include SUMO axioms
include('Axioms/CSR005^0.ax').
%------------------------------------------------------------------------------
%----The extracted signature
thf(lBill_THFTYPE_i,type,
    lBill_THFTYPE_i: $i ).

thf(lMary_THFTYPE_i,type,
    lMary_THFTYPE_i: $i ).

thf(lSue_THFTYPE_i,type,
    lSue_THFTYPE_i: $i ).

thf(likes_THFTYPE_IiioI,type,
    likes_THFTYPE_IiioI: $i > $i > $o ).

thf(n2009_THFTYPE_i,type,
    n2009_THFTYPE_i: $i ).

%----The translated axioms
thf(ax,axiom,
    ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i )
    @ ( ( likes_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i )
      & ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i ) ) ) ).

%----The translated conjecture
thf(con,conjecture,
    ? [Y: $i] : ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( likes_THFTYPE_IiioI @ Y @ lBill_THFTYPE_i ) ) ).

%------------------------------------------------------------------------------
